(in-package "MRS")
;;; Globals for YGG

(defparameter *mrs-to-vit* nil)

(defparameter *mrs-for-language* 'english)

(defparameter *mrs-scoping* nil)

(defparameter *alex-munge* nil)

(defparameter *initial-semantics-path* `(,(vsym "SEM") ))

(defparameter *main-semantics-path* `(,(vsym "LISZT") ,(vsym "LIST")))

;(defparameter *main-semantics-path* `(,(vsym "SEM") ,(vsym "LISZT") ,(vsym "LIST")))

;(defparameter *top-semantics-type* (vsym "RELN"))

(setf *top-semantics-type* 
  (vsym "RELATION"))


(defparameter *construction-semantics-path* `(,(vsym "SEM") ,(vsym "LISZT") ,(vsym "LIST")))

(defparameter *rel-name-path* nil)

(defparameter *rel-name-path-only* t)

(defparameter *rel-handel-path*
    `(,(vsym "HANDEL"))
  "path to get the handel from a relation")

#|
SEM [sem-struc
     MODE ref
     INDEX ref-index <8>
     LISZT list-of-predications
           LIST 
                FIRST noun_pred
                      RELN r_ande
                      SIT sit-index
                      INSTANCE <8>
                REST <9>
           LAST <9>
|#

(defparameter *value-feats* `(,(vsym "NAME") ,(vsym "CONST_VALUE" )))

;(defparameter *value-feats* `(,(vsym "NAME")))

(defparameter *psoa-top-h-path* nil)
(defparameter *psoa-event-path* `(,(vsym "INDEX")))
(defparameter *psoa-liszt-path* `(,(vsym "LISZT") ,(vsym "LIST")))
(defparameter *psoa-rh-cons-path* nil)

;;;

(setf *ignored-sem-features* `(,(vsym "LABEL") ,(vsym "RELN")))

;(setf *ignored-sem-features* `(,(vsym "LABEL")))

(setf *construction-semantics-path*
  `(,(vsym "C-CONT") ,(vsym "LISZT") ,(vsym "LIST")))

(defparameter *psoa-rh-cons-path*
    `(,(vsym "H-CONS") ,(vsym "LIST"))
  "path to get a list of handle constraints from a root psoa")

(defparameter *initial-semantics-path* 
  `(,(vsym "SEM"))
  "Following this path into a sign gets you to the MRS structure")

(defparameter *psoa-index-path* 
  `(,(vsym "INDEX"))
  "path to get an index from a psoa")
